////////////////////////////////////////////////////////////////////////////////
//	File	:	"Messages.h"
//
//	Author	:	Sean Murray
//
//	Purpose	:	This class is used to store all the message declarations in the game.		
////////////////////////////////////////////////////////////////////////////////
#pragma once
#include <windows.h>	//	for POINT

class CBase;

enum eMessageTypes
{
	MSG_NULL = 0,
	MSG_CREATE_GOOD_NOTE,
	MSG_CREATE_BAD_NOTE,
	MSG_CREATE_BULLET,
	MSG_DESTROY_NOTE,
	MSG_DESTROY_BULLET,


	// insert your message here
	
	MSG_MAX		// My total number of messages
};

typedef unsigned int MESSAGEID; // incase you want to change the message id type

class CBaseMessage
{
private:
	MESSAGEID	m_Msg;		//	The message id
public:
	CBaseMessage(MESSAGEID msg = MSG_NULL) { m_Msg = msg; }
	virtual ~CBaseMessage(void) {}

	//	Accessor
	inline MESSAGEID GetMessageID(void) { return m_Msg; }
};




class CCreateGoodNoteMessage : public CBaseMessage
{
	CBase* m_pNote;
	float m_fPosX;
	float m_fPosY;
	float m_fVelX;
	int m_nNoteType;

	public:
	CCreateGoodNoteMessage(CBase* pNote, float PosX, float PosY, float VelX, int nNoteType) : CBaseMessage(MSG_CREATE_GOOD_NOTE) 
	{ 
		m_pNote = pNote;
		m_fPosX = PosX;
		m_fPosY = PosY;
		m_fVelX = VelX;
		m_nNoteType = nNoteType;
	}

	//	Accessors
	CBase* GetGoodNote(void)	{ return m_pNote; }
	float GetPosX(void) {return m_fPosX;}
	float GetPosY(void) {return m_fPosY;}
	float GetVelX(void) {return m_fVelX;}
	int GetNoteType(void) {return m_nNoteType;}
};


class CCreateBadNoteMessage : public CBaseMessage
{
	CBase* m_pNote;
	float m_fPosX;
	float m_fPosY;
	float m_fVelX;
	int m_nNoteType;

	public:
	CCreateBadNoteMessage(CBase* pNote, float PosX, float PosY, float VelX, int nNoteType) : CBaseMessage(MSG_CREATE_BAD_NOTE) 
	{ 
		m_pNote = pNote;
		m_fPosX = PosX;
		m_fPosY = PosY;
		m_fVelX = VelX;
		m_nNoteType = nNoteType;
	}

	//	Accessors
	CBase* GetBadNote(void)	{ return m_pNote; }
	float GetPosX(void) {return m_fPosX;}
	float GetPosY(void) {return m_fPosY;}
	float GetVelX(void) {return m_fVelX;}
	int GetNoteType(void) {return m_nNoteType;}
};

class CDestroyNoteMessage : public CBaseMessage
{
	CBase* m_pNote;

	public:
	CDestroyNoteMessage(CBase* pNote) : CBaseMessage(MSG_DESTROY_NOTE) 
	{ 
		m_pNote = pNote;
	}

	//	Accessors
	CBase* GetNote(void)	{ return m_pNote; }

};

class CCreateBulletMessage : public CBaseMessage
{
	CBase* m_pPlayer;

public:
	CCreateBulletMessage(CBase* player) : CBaseMessage(MSG_CREATE_BULLET)
	{
		m_pPlayer = player;
	}

	//Accessors
	CBase* GetPlayer() {return m_pPlayer;}
};

class CDestroyBulletMessage : public CBaseMessage
{
	CBase* m_pBullet;

public:
	CDestroyBulletMessage(CBase* pBullet) : CBaseMessage(MSG_DESTROY_BULLET)
	{
		m_pBullet = pBullet;
	}

	//Accesoors
	CBase* GetBullet(void) {return m_pBullet;}
};

/////////////////////////////////////////////
//
//	EXAMPLE MESSAGE
//
//class CCreateElementGeneratorMessage : public CBaseMessage 
//{ 
//private:   
//	int m_nElementType; // An integer to hold the element type.
//	int m_nX;			// The x position of the mouse click.
//	int m_nY;			// The y position of the mouse click.
//	int m_nI;			// The i index of the Ground.
//	int m_nJ;			// The j index of the Ground.
//	public: 
//	CCreateElementGeneratorMessage(int nElementType, int nX, int nY) : CBaseMessage(MSG_CREATE_ELEMENTGENERATOR) 
//	{ 
//		m_nElementType = nElementType; // Set the element type.
//		// Algorithm for indexing by tile array, or indexing by pixel.
//		if(nX < 200)
//			nX = 200;
//		if(nY < 55)
//			nY = 55;
//		if(nX > 744)
//			nX = 712;
//		if(nY > 599)
//			nY = 567;
//		m_nI = (nX - 200) / 32; 		  
//		m_nJ = (nY - 55) / 32; 
//		m_nX = (m_nI * 32) + 200; 
//		m_nY = (m_nJ * 32) + 55;   
//	} 
//	  
//	inline int GetElementType(void) {return m_nElementType; } 
//	inline int GetFirstIndex(void) {return m_nI; } 
//	inline int GetSecondIndex(void) {return m_nJ; } 
//	inline int GetPosX(void) {return m_nX; } 
//	inline int GetPosY(void) {return m_nY; }   
//};